%
% --------------------------------------------------------------
% function [s]=FT_log_ticks(ticks)
%
% Matlab function to generate a string for manually setting
% major tick marks in a plot
%
% How to use:
% e.g. cticks = get(gca,'YTick')
% tickstr=FT_log_ticks(cticks);
% set(gca,'YTickLabel',tickstr)
%
% Andreas Freise 18.08.2009
% --------------------------------------------------------------
%

% Description: Generates a string for setting major tick marks in a plot
% Keywords: major, tick, mark, plot, log

function [tickstr]=FT_log_ticks(mticks)
  [rows,cols]=size(mticks);
  maxl=0;
  for i=1:cols
    tvalue=abs(mticks(i));
    tsign=sign(mticks(i));
    if (tvalue==0)
      templist(i)={sprintf('0.0')};
    else
      exponent=floor(log10(tvalue));
      newvalue=tvalue/10.^exponent;
      if (tsign==-1)
        signstr='-';
      else
        signstr=' ';
      end
      
      tempstr=sprintf('%s%2.1f 10^%d',signstr,newvalue,exponent);
      templist(i)={tempstr};
      templ=length(tempstr);
      if(templ>maxl)
        maxl=templ;
      end
    end
  end

  % padding the strings with spaces and returning an string array
  for i=1:cols
    tmp=[char(abs(' ')*ones(1,maxl)) cell2mat(templist(i))];
    tmpl=length(tmp);
    tickstr(i,:)=sprintf('%s',tmp(1+tmpl-maxl:tmpl));
  end
  
