% ------------------------------------------------------
% function [L] = LaguerrePol (p,l,x)
% 
% Matlab/Octave function to compute the 
% associated Laguerre Polynomial L_p^l (x).
%
%                p    1   / l+p \       
% L_p^l(x)=   Sum    ---  |     |  (-x)^j
%              j=0   j!   \ p-j /    
%
% p,l (int)
% x (real)
%
% L (real)
%
% Andreas Freise 25.03.2007
%---------------------------------------------------------


 function [L] = LaguerrePol (p,l,x)

   L=0;
   for j=0:p
     L=L+nchoosek(l+p,p-j)/factorial(j)*(-x).^j;
   end
return