% ------------------------------------------------------
% function [P] = FT_JacobiPol (a,b,n,x)
% 
% Matlab/Octave function to compute the 
% Jacobi Polynomial P_n^{a,b} (x)for real x.
%
%                 n    / n+a \ / n+b \ / x-1 \^(n-s) / x+1 \^s
% P_n^{a,b}(x)= Sum    |     | |     | | --- |       | --- |
%                s=0   \ s   / \ n-s / \  2  /       \  2  /
%
% n,a,b (int)
% x (real)
%
% P (real)
%
% Part of the Simtools Package, http://www.gwoptics.org/simtools
% Andreas Freise 25.03.2007
%---------------------------------------------------------------

% Description: computes the Jacobi polynomial
% Keywords: Jacobi, polynomial

function [P] = FT_JacobiPol (a,b,n,x)
  P=0;
  for s=0:n
    P=P+FT_bincoeff(n+a,s).*FT_bincoeff(n+b,n-s).*(x-1).^(n-s).*(x+1).^s;
  end
  P=P*0.5^(n);
  
return
  