%
%--------------------------------------------------------------------------
% function [outstring]=FT_remove_file_extension(instring)
%
% A function for Matlab which removes the file extension (i.e. .txt)
% from a given string.
%
% instring: input string
% outstring: output string
%
% Charlotte Bond  18.07.2008
%--------------------------------------------------------------------------
%

function [outstring]=FT_remove_file_extension(instring)

baseid='remove_file_extension';

% Remove text after the last '.'
nl=length(instring);
dot=find(instring=='.');
dl=length(dot);

% If the filename contains no dots it remains unchanged, if it does contain
% any the last dot and text after it are removed.

if(dl)
  string_end=dot(dl)-1;
  if(string_end<1)
    msgid=[baseid,':finddot'];
    result='text parsing error'
    error(msgid,result);
  end
  outstring=instring(1:string_end);
else
  outstring=instring;
end
