%---------------------------------------------------------------------  
% function []=FT_make_backup(filename)
% 
% Makes a backup file (adds a '.bak') of a given filename
%
% filename: string, contains the name of the file
%
% Part of the SimTools package
% Andreas Freise 22.05.08 afreise@googlemail.com
%---------------------------------------------------------------------  

function []=FT_make_backup(filename)
  
  baseid='FT_make_backup';

  if (~isstr(filename))
    msgid=[baseid,':checkinarg'];
    result='input argument must be a filename';
    error(msgid,result);
  end
  
  % check whether name contains / or \ so its
  % filename including the path
  
  ispath=0;
  if (strfind(filename,'\'))
    ispath=1;
  end
  
  if (strfind(filename,'/'))
    ispath=1;
  end
  
  if (ispath==0)
    filename=['./',filename];
  end
  
  backupname=[filename,'.bak'];
  if (exist(filename))
    [status,result,msgid] = copyfile(filename,backupname,'f');
  
    if (status)
      error(msgid,result);
    end
  end
  