%
%------------------------------------------------------------------
% function [found] = FT_find_text_in_file(FID, text_string)
%
% Function for Matlab, scans a file for a given string and stops at 
% its first occurence. Returns an 1 or 0 to indicate whether string has
% been found.
% 
% FID: File indicator, must have been created with fopen before
% text_string: string to be searched for
% found: integer: 0 text has not bee found, 1 text has been found
%
% Andreas Freise  09.07.2008
%------------------------------------------------------------------
%

function [found] = FT_find_text_in_file(FID, text_string)
  
  baseid='find_text_in_file';
   
  line_number=0;
  found=0;

  while (~feof(FID) && found==0)
    text_line = fgetl(FID);
    line_number=line_number+1;

    if (text_line == -1)
      msgid=[baseid,':read_line'];
      result='Could not read line from file';
      error(msgid,result);
    end

    if (ischar(text_line))
      pos=strfind(text_line, text_string);
      if (pos)
        found=1;
      end
    end
  end
 
  
      