%
%--------------------------------------------------------------------------
% function [files]=FT_files_in_folder(folder, extension)
%
% A function for Matlab that returns all files names with a given
% extension in the specified folder
% 
% folder: String, name of folder
% extension: String, file extension, e.g. 'txt'
%
% files: String[], array of file names
%
% Part of the Simtools package, http://www.gwoptics.org/simtools
% Andreas Freise  07.04.2010
% Borja Sorazu    13.04.2011
%--------------------------------------------------------------------------
%

% Description: Lists all files with a given extension in a folder
% Keywords: file, list, folder

function [files]=FT_files_in_folder(folder, extension)

  baseid='FT_files_in_folder';

  folder=strtrim(folder);

  if (~isdir(folder))
    msgid=[baseid,':checkinarg'];
    result=['cannot fine folder named ',folder];
    error(msgid,result);
  end
  
  % Using the right slash based on the running operating system
  OS = computer;
  OS = OS(1:2);
  if strcmpi(OS, 'pc')
      slash_os = '\';
      slash_nos = '/';
  else
      slash_os = '/';
      slash_nos = '\';
  end
  folder = strrep(folder, slash_nos, slash_os);
  
  % End the folder name with the right slash for the running OS
  if (folder(end) ~= slash_os)
    folder=[folder, slash_os];
  end

  % Managing the file extension
  if (isempty(extension))
    extension='*';
  else
    if strcmp(extension(1),'.')
      extension=['*',extension];
    else
      extension=['*.',extension];
    end
  end

  folder_tmp=[folder,extension];
  filesdata = dir(folder_tmp);
  N = length(filesdata);
  files = cell(1,N);
  for j=1:N
    files{j}=[folder,filesdata(j).name];
  end