%---------------------------------------------------------------------  
% function []=FT_delete_file(filename)
% 
% deletes a file, USE CAREFULLY!
%
% filename: string, contains the name of the file
%
% Part of the SimTools package
% Andreas Freise 16.06.08 afreise@googlemail.com
%---------------------------------------------------------------------  

function []=FT_delete_file(filename)
  
  baseid='FT_delete_file';

  if (~isstr(filename))
    msgid=[baseid,':checkinarg'];
    result='input argument must be a filename';
    error(msgid,result);
  end
  
  % check whether name contains / or \ so its
  % filename including the path
  
  ispath=0;
  if (strfind(filename,'\'))
    ispath=1;
  end
  
  if (strfind(filename,'/'))
    ispath=1;
  end
  
  if (ispath==0)
    filename=['./',filename];
  end
  
  if (exist(filename))
    %disp(sprintf('deleting %s',filename));
    delete(filename);
  else
    %disp(sprintf('cannot delete %s, file does not exist',filename));
  end
  
  