%
%--------------------------------------------------------------------------
% function [filename]=FT_check_for_gzip(filename)
%
% A function for Matlab which checks if a filename ends in `.gz'. If
% so it calls the gunzip function to unzip the file and returns the
% filename of the unzipped file. If the unzipped file already exists
% (filename without the .gz) then it is not overwritten!
%
% filename: name of file
%
% Part of the Simtools package, http://www.gwoptics.org/simtools
% 10.05.2011    Andreas Freise
%--------------------------------------------------------------------------
%

% Description: Checks if a filename ends in .gz and if so unzips it
% Keywords: file, gzip, unzip, zip

function [filename]=FT_check_for_gzip(filename)

 baseid='check_for_gzip';

  if (~isstr(filename))
    msgid=[baseid,':checkinarg'];
    result='input argument must be a filename';
    error(msgid,result);
  end

 if (exist(filename))
    [path, fname, ext] = fileparts(filename);
    if (strcmp(ext,'.gz')) 
      newfile=[path, fname];
      if exist(newfile)
        FT_warning(sprintf('unzipped file %s already exists and is not overwritten',newfile));
        filename=newfile;
      else
        FT_message(sprintf('unzipping %s',filename));
        filename=cell2mat(gunzip(filename));
      end
    end
  else
    msgid=[baseid,':checkinarg'];
    result=sprintf('cannot unzip %s, file does not exist',filename);
    error(msgid,result);
  end

