%
%---------------------------------------------------------------------  
% function [map]=FT_flip_colormap()
% 
% Matlab function that returns colormap which I find nice for 
% bipolar signals
%
% map: colormap (3x64 sizes matrix, values between 0 and 1)
%
% Part of the Simtools package
% Andreas Freise 22.05.08 afreise@googlemail.com
%---------------------------------------------------------------------  
%

% Description: Returns colormap, good for bipolar signals
% Keywords: colormap, colourmap, color, colour, bipolar, flip

function [map]=FT_flip_colormap()

  grayscale=linspace(0,1,64);
  x=grayscale;
  y=abs(1-2*x);
  f7=sqrt(y);
  f5=y.^3;
  f6=y.^4;
  f15=abs(sin(2*pi*y));
  f9=sin(0.5*pi*y);
  flip76=0.5*((sign(x-0.5)+1).*f7+(1-sign(x-0.5)).*f6);
  flip59=0.5*((sign(x-0.5)+1).*f5+(1-sign(x-0.5)).*f9);
  map=[flip76; flip59; f15]';
  
  

