%
%--------------------------------------------------------------------------
% function FT_warning(message)
%
% A function for Matlab which prints a warning message. This function
% is meant as a template to change/remove the way SimTools function
% print messages.
%
% message String to be printed
%
% Part of the Simtools package, http://www.gwoptics.org/simtools
% 10.05.2011    Andreas Freise
%--------------------------------------------------------------------------
%

% Description: prints a message to stdout
% Keywords: print, message, warning

function FT_warning(message)
  
 baseid='warning';

  if (~isstr(message))
    msgid=[baseid,':checkinarg'];
    result='input argument must be a string';
    error(msgid,result);
  end
  
  fprintf('  ** %s **\n',message);

end
  

