%
%--------------------------------------------------------------------------
% function [data_out]=FT_remove_piston_data(data_in)
%
% A function for Matlab that remove a 'tilt' from a 2D data array
% 
% data_in:   2D data grid
%
% data_out:   2D data grid
%
% Andreas Freise  12.08.2009
%--------------------------------------------------------------------------
%

% Description: Removes a tilt from a 2D data array
% Keywords: remove, tilt, 2D, piston, data

function [data_out]=FT_remove_piston_data(data_in)
  
  [rows,cols]=size(data_in);
  y=linspace(1,rows,rows);
  x=linspace(1,cols,cols);
  
  X=sum(data_in);
  Y=sum(data_in');
  
  [pX]=polyfit(x,X,1);
  [pY]=polyfit(y,Y,1);
 
  %{
  figure
  plot(x,X,x,pX(2)+pX(1).*x,x,X./(pX(2)+pX(1).*x));
  figure
  plot(y,Y,y,pY(2)+pY(1).*y,y,Y./(pY(2)+pY(1).*y));
  %}
  
  scaling=meshgrid(pX(2)+pX(1).*x,pY(2)+pY(1).*y).*meshgrid(pY(2)+pY(1).*y,pX(2)+pX(1).*x)';
  
  
  data_out=data_in./scaling;
  data_out=FT_normalise_data(data_out,0,1);

  %{
  figure 
  surf(data_in,'Edgecolor','none')
 %}