%
%--------------------------------------------------------------------------
% function [data_out]=FT_normalise_data(data_in,min_value, max_value)
%
% A function for Matlab that normalises a data set so that max/min values 
% are those given by the user
% 
%
% data_in:   2D data grid
% min_value: user defined minimum value
% max_value: user defined maximum value
%
% data_out:  normalised 2D data grid
%
% Andreas Freise  12.08.2009
%--------------------------------------------------------------------------
%

% Description: Normalises a data set so that max/min values are those given by user
% Keywords: normalise, data, max, min, maximum, minimum

function [data_out]=FT_normalise_data(data_in,min_value, max_value)
  
  data_out=data_in;
  data_out=data_out-min(min(data_out));
  data_out=data_out/max(max(data_out))*(max_value-min_value);
  data_out=data_out+min_value;
  
 