%---------------------------------------------------------------------  
% function [filename] = FT_create_tmp_filename(string, extension)
% 
% Matlab function that creates a name for temporary files as
% string+datestring+extension, with datestring being the current 
% date and time formated as yyyy-mm-dd++HH-MM-SS.
% 
% string (string): beginning of filename
% extension (string): extension including the '.', e.g. '.txt'.
%                     (set to '' if you want to create a basename instead)
%
% filename (string): filename
%
% Part of the SimTools package
% Andreas Freise, 19.12.2009 afreise@googlemail.com
%---------------------------------------------------------------------  

% Description: Creates a name for temporary files using the current datestring
% Keywords: date, time, datetime, datestring, temporary, create, tmp, filename

function [filename] = FT_create_tmp_filename(string, extension)

  datestr=FT_datestring();
  filename=sprintf('%s%s%s',string,datestr,extension);
  
  return
