%
%--------------------------------------------------------------------------
% function [center]=FT_center_of_mass(data)
%
% A function for Matlab which computes the center of mass of 
% a data array and returns the coordinates as row and column index
% 
% data:     vector or 2D data array
%
% center:   2D vector pointing to center of mass
%
% Andreas Freise  23.07.2009
%--------------------------------------------------------------------------
%

% Description: Computes the center of mass of a data array and returns the coordinates
% Keywords: center, centre, mass, com, data

function [center]=FT_center_of_mass(data)

baseid='center_of_mass';

[rows,cols]=size(data);

% make sure dta is all positive
data=abs(data);

% compute total mass
M=sum(sum(data));

x=linspace(1,cols,cols);
y=linspace(1,rows,rows);
xx=meshgrid(x,y);
yy=meshgrid(y,x)';
x=sum(sum(data.*xx))/M;
y=sum(sum(data.*yy))/M;

center=[y,x];

