%
%--------------------------------------------------------------------------
% function [data_out,offset]=FT_box_data(data_in,threshold)
%
% A function for Matlab selects a subset of a 2D data grid, such that
% it contains all data > threshold
%
% data_in:   2D data grid
% threshold: minimum value of data to be returned
%
% data_out:  2D data grid
% offset:    2D vector giving offset between data_out and data_in in number 
%            of rows and cols
%
% Andreas Freise  23.07.2009
%--------------------------------------------------------------------------
%

% Description: Selects a subset of a 2D data grid,
% Description: such that it contains all data > threshold
% Keywords: box, data, subset, 2D, threshold

function [data_out,offset]=FT_box_data(data_in,threshold)
  
  [rows,cols]=size(data_in);
  [rs,cs]=find(data_in>threshold);
  rmin(1)=min(rs);
  rmin(2)=min(cs);
  rmax(1)=max(rs);
  rmax(2)=max(cs);
  
  data_out=data_in(rmin(1):rmax(1),rmin(2):rmax(2));
  offset=rmin;