
%
%--------------------------------------------------------------------------
% function [data_out]=FT_blur_data(data_in, pixel, sigma)
%
% A function for Matlab that blurs a 2D data array with a gaussian filter
% 
% data_in:   2D data grid 
% pixel:     width of the filter
% sigma:     sigma of the gaussian filter
%
% data_out:   2D data grid 
% radius: beam size (w) [...]
%
% Andreas Freise  12.08.2009
%--------------------------------------------------------------------------
%

% Description: Blurs a 2D data array with a Gaussian filter
% Keywords: blur, 2D, Gaussian, filter, data

function [data_out]=FT_blur_data(data_in, pixel, sigma)
 
     size = (pixel-1)/2;
     window = [size,size];     
     [x,y] = meshgrid(-window(2):window(2),-window(1):window(1));
     arg = -(x.*x + y.*y)/(2*sigma*sigma);
     h = exp(arg);
     h(h<eps*max(h(:))) = 0;
     sumh = sum(h(:));
     if sumh ~= 0,
       h  = h/sumh;
     end;
     
     data_out=conv2(data_in,h,'same');
     