%---------------------------------------------------------------------  
% function [outstring] = FT_uncomment_line(instring)
% 
% Remove all comment chars ('%' or '#') from the beginning of a string
% a string.
%
% instring: string, one line of text
% outstring: string starting not with a comment sign
%
% Part of the SimTools package
% Andreas Freise 22.05.08 afreise@googlemail.com
%---------------------------------------------------------------------  

function [outstring] = FT_uncomment_line(instring)
  
  tmpstring=strtrim(instring);

  comments={'%', '#'};
  n_comments=2;

  found=1;
  inlength=length(tmpstring);
  notend=1;
  
  while(found==1 && notend)
    if (tmpstring)
      found=0;
      for i=1:n_comments
        if (tmpstring(1)==cell2mat(comments(i)))
          found=1;
          i=n_comments;
          tmpstring=strtrim(tmpstring(2:length(tmpstring)));
        end
      end
    else
      notend=0;
    end
  end
  outstring=tmpstring;
