%---------------------------------------------------------------------  
% function [outstring] = FT_replace_value_in_line(instring, position, value)
% 
% Replaces one element in a string by a new value. The element
% is indicated by the integer position
%
% instring: string, containing one line of text from a text file
% position: integers, specifying which elements should be replaced
% value: double or string which will be inserted into string
% outstring: string, containing new element
%
% Part of the SimTools package
% Andreas Freise 22.05.08 afreise@googlemail.com
%---------------------------------------------------------------------  

function [outstring] = FT_replace_value_in_line(instring, position, value)

  % base string for error message id
  baseid='FT_replace_value_in_line';

  if (iscell(instring))
    instring=cell2mat(instring);
  end
  
  if (~isstr(instring))
    msgid=[baseid,':checkinarg'];
    msg='first input argument must be a text line';
    error(msgid,msg);
  end
  
  pos=int8(position);
  if(pos~=position)
    msgid=[baseid,':checkinarg'];
    msg='second input argument must be of type integer';
    error(msgid,msg);    
  end
  
  [element,estart,eend]=FT_get_element_from_line(instring, position);
  
  if (estart==1)
    str1='';
  else
    str1=instring(1:estart);
  end
  
  if (isstr(value))
    str2=value;
  else
    str2=num2str(value);
  end

  
  outstring=[str1,str2,instring(eend:length(instring))];
  
