%--------------------------------------------------------------------------
% function [outstring] = FT_remove_phrase_from_string(instring,phrase)
%
% A Matlab function which removes the string phrase from string if it is 
% part of the original string.
%
% instring: original string
% phrase:   string to be removed
% outsrtin: original string with phrase removed
%
% 18.12.2010    Charlotte Bond
%--------------------------------------------------------------------------
%


function [outstring] = FT_remove_phrase_from_string(instring,phrase)

    baseid='remove_phrase_from_srting';

    % Length of string and phrase to be compared
    ls=length(instring);
    lp=length(phrase);
    
    outstring=instring;
    
    % Look through string and compare parts of instring to phrase
    for n=0:ls-lp
        
        if strcmp(instring(1+n:lp+n),phrase)
            
            % If the phrase is present in the string take the previous
            % letters and letters after phrase
            if n~=0
                os_start=instring(1:n);
            else
                os_start='';
            end
            
            if n~=ls-lp
                os_end=instring(lp+n+1:ls);
            else
                os_end='';
            end
            
            outstring=[os_start os_end];
        end
    end
            


end

