%---------------------------------------------------------------------  
% function [outstring] = FT_remove_comment_line(instring)
% 
% Output the given string unchanged, unless its first character is
% a '%' or '#', in which case an empty string is returned
%
% instring: string input
% outstring: string output
%
% Part of the SimTools package
% Andreas Freise 22.05.08 afreise@googlemail.com
%---------------------------------------------------------------------  

function [outstring] = FT_remove_comment_line(instring)

  if (iscell(instring))
    outstring=strtrim(cell2mat(instring));
  else
    outstring=strtrim(instring);
  end
  
  comments={'%', '#'};
  n_comments=2;
  
  for i=1:n_comments
    if (outstring)
      if (outstring(1)==cell2mat(comments(i)))
        outstring='';
      end
    else
      i=n_comments;
    end
  end
  