%---------------------------------------------------------------------  
% function [outstring] = FT_remove_comment_from_line(instring)
% 
% Output the given string unchanged, unless its first character is
% a '%' or '#', in which case an empty string is returned
%
% instring: string input
% outstring: string output
%
% Part of the SimTools package
% Andreas Freise 22.05.08 afreise@googlemail.com
%---------------------------------------------------------------------  

function [outstring] = FT_remove_comment_from_line(instring)

  tmpstring=strtrim(instring);

  posc1=strfind(tmpstring,'%');
  posc2=strfind(tmpstring,'#');

  if (any(posc1) | any(posc2))
    if (posc1)
      if (posc2)
        if (min(posc1)>min(posc2))
          endpos=min(posc2)-1;
        else
          endpos=min(posc1)-1;
        end
      else
        endpos=min(posc1)-1;
      end
    else
      endpos=min(posc2)-1;
    end
  else
    endpos=length(tmpstring);
  end

  if (endpos==0)
      outstring='';
  else
    outstring=strtrim(tmpstring(1:endpos));
  end
  