%---------------------------------------------------------------------  
% function [outstring] = FT_remove_comment_char_from_line(instring)
% 
% Remove one comment char '%' or '#' is that is the first character of
% a string.
%
% instring: string, one line of text
% outstring: string intext with a '%' in front
%
% Part of the SimTools package
% Andreas Freise 22.05.08 afreise@googlemail.com
%---------------------------------------------------------------------  

function [outstring] = FT_remove_comment_char_from_line(instring)
  
  outstring=strtrim(instring);

  comments={'%', '#'};
  n_comments=2;
  
  for i=1:n_comments
    if (outstring)
      if (outstring(1)==cell2mat(comments(i)))
        outstring=strtrim(outstring(2:length(outstring)));
      end
    else
      i=n_comments;
    end
  end

