%---------------------------------------------------------------------  
% function [values] = FT_parse_line(instring, positions)
% 
% Splits the input string and returns the word or numbers
% of the elements specified by positions
%
% instring: string, containing one line of text from a text file
% positions: vector of integers, specifying which elements should
%            be returned
% values: cell structure containing strings or double values for 
%         specified elements
%
% Part of the SimTools package
% Andreas Freise 22.05.08 afreise@googlemail.com
%---------------------------------------------------------------------  

function [values] = FT_parse_line(instring, positions)

  % base string for error message id
  baseid='FT_parse_line';

  if (iscell(instring))
    instring=cell2mat(instring);
  end
  
  if (~isstr(instring))
    msgid=[baseid,':checkinarg'];
    msg='first input argument must be a text line';
    error(msgid,msg);
  end
  
  pos=int8(positions);
  if(pos~=positions)
    msgid=[baseid,':checkinarg'];
    msg='second input argument must be of type integer';
    error(msgid,msg);    
  end
  
  tmpstring=FT_remove_comment_from_line(instring);

  %cells=regexp(tmpstring, '\s+', 'split');
  cells=FT_split_line(tmpstring, '');
  
  n_values=length(cells);
  
  if (max(pos)>n_values)
    msgid=[baseid,':checkinarg'];
    msg='requested position does not exist';
    error(msgid,msg);    
  end  


  tmpvalues=str2double(cells);
  
  j=1;
  for i=pos
    if (isnan(tmpvalues(i)))
      values{j}=cells(i);
    else
      values{j}=tmpvalues(i);
    end
    j=j+1;
  end
  
  