%---------------------------------------------------------------------  
% function [element,start,end] = FT_get_element_from_line(instring, position)
% 
% Returnes one element in a string. The element
% is indicated by the integer position
%
% instring: string, containing one line of text from a Finesse file
% position: integer, specifying which elements
% elements: string, containg elements
% start,end: index giving start and stop index for element in instring
%
% Part of the SimTools package
% Andreas Freise 22.05.08 afreise@googlemail.com
%---------------------------------------------------------------------  

function [element,estart,eend] = FT_get_element_from_line(instring, position)

% base string for error message id
  baseid='FT_get_element_from_line';

  if (iscell(instring))
    instring=cell2mat(instring);
  end
  
  if (~isstr(instring))
    msgid=[baseid,':checkinarg'];
    msg='first input argument must be a text line';
    error(msgid,msg);
  end
  
  pos=int8(position);
  if(pos~=position)
    msgid=[baseid,':checkinarg'];
    msg='second input argument must be of type integer';
    error(msgid,msg);    
  end
  
  tmpstring=FT_remove_comment_from_line(instring);
  %  cells=regexp(tmpstring, '\s+', 'split');
  cells=FT_split_line(tmpstring, '');
  n_values=length(cells);
  
  [endpos,startpos]=regexp(tmpstring, '\s+');
  startpos=[1,startpos];
  endpos=[endpos,length(tmpstring)+1];

  
  if (max(pos)>n_values)
    element=[];
    estart=[];
    eend=[];
  else
    element=cell2mat(cells(pos));
    estart=startpos(pos);
    eend=endpos(pos);
  end
  
