%
%---------------------------------------------------------------------  
% function [space] = FT_init_space(varargin)
% 
% Matlab function that creates a structure `space' storing 
% parameter of the optical component `space' resembling a 
% free propagation through space (or a homogeneous medium).
%
% Usage for example:
%  space=FT_init_space('L',3.2)
% or
%  space=FT_init_space('L',3.2,'n',1.45)
%
% The following (optional) parameters can be given by the user:
% L - length [m]
% n - index of refraction
% name - string
%
% If no values are provided by the user the structure the
% following defaults:
% L = 1
% n = 1
% name =''
% space = 1 (this field is used only to identify the structure as a space)
%
% Part of the SimTools package
% Andreas Freise, 26.12.2009 afreise@googlemail.com
%---------------------------------------------------------------------  
%

% Description: Creates "space" structure for storing parameters of a free space
% Keywords: init, free, space, structure, parameter, propagation

function [space] = FT_init_space(varargin)

   baseid='init_space';

   %%% initialise `mirror' structure
   space.L=1;
   space.n=1;
   space.name='';
   space.space=1;

   %%% parse input arguments
   if nargin > 0
     % check which calling syntax is used
     actual_n=1;
     while actual_n<=nargin-1
       switch lower(varargin{actual_n})
        case 'l',
         space.L = varargin{actual_n+1};
        case 'n',
         space.n = varargin{actual_n+1};
        case 'name',
         space.name = varargin{actual_n+1};
        otherwise ,
          msgid=[baseid,':checkinarg'];
          result=sprintf(['Unknown option: ', varargin{actual_n}, '.\n']);
          error(msgid,result);
       end;   
       actual_n=actual_n+2;
     end;  
   end
   
   %%% check input arguments
   if (space.L<0 ||space.n<=0)
     msgid=[baseid,':checkinarg'];
     result=sprintf('L and n cannot be negative.\n');
     error(msgid,result);
   end

   if (~ischar(space.name))
     msgid=[baseid,':checkinarg'];
     result=sprintf('name must be a string.\n');
     error(msgid,result);
   end   
   
   return