%
% ------------------------------------------------------------------
% function [Rc] = FT_cavity_w2Rc(w, L, lambda)
%
% Function for Matlab that computes, for a linear, symmetric
% cavity, the mirror radius of curvature from the beamsize
% on the mirror.
% 
% w (real):      beam radius [m]
% lambda (real): wavelength [m]
% L (real):      cavity length [m]
%
% Rc (real):     2-element vector, mirror radiusof curvature [m] 
%
% Part of the SimTools package
% A. Freise 01.04.2010 adf@star.sr.bham.ac.uk
% ------------------------------------------------------------------
%

% Description: Computes mirror radius of curvature from beamsize for
% Description: a linear, symmetric cavity
% Keywords: radius, curvature

function [Rc] = FT_cavity_w2Rc(w, L, lambda)

  % function derivd from
  % 
  % w^2=L lambda/pi sqrt(1/(1-g^2))
  %   
  
  g1 = sqrt(1- (L.*lambda./(w.^2.*pi)).^2);
  g2 = -1.0*sqrt(1- (L.*lambda./(w.^2.*pi)).^2);
  
  Rc1=L/(1-g1);
  Rc2=L/(1-g2);
  
  Rc=[Rc1,Rc2];