%
%---------------------------------------------------------------------  
% function [Psi] = FT_cavity_roundtrip_Gouy(cavity)
% 
% computes the roundtrip Gouy phase of a cavity eigenmode.
%
% cavity: structure storing cavity parameters
%
% Psi (real): Gouy phase for a full roundtrip
%
% Andreas Freise 11.02.10 afreise@googlemail.com
%---------------------------------------------------------------------  
%

% Description: Computes the roundtrip Gouy phase of a cavity eigenmode
% Keywords: Guoy, phase, roundtrip, eigenmode

function [Psi] = FT_cavity_roundtrip_Gouy(cavity)
  
  [M,m]=FT_compute_cavity_ABCD(cavity);
  [q] = FT_cavity_ABCD_to_q(M,1);
  
  clast=cavity.ncomponents;

  Psi=0.0;
  
  for p=1:clast
    Ms = FT_ABCD_space(cavity.space(p).L, cavity.space(p).n);
    Psi1=FT_q_to_Psi(q);
    q=FT_q_ABCD_q(Ms,q,1,1);
    Psi2=FT_q_to_Psi(q);
    Psi=Psi+Psi2-Psi1;
    Mm = FT_ABCD_mirror(cavity.mirror(p).Rc,cavity.mirror(p).alpha,1);
    q=FT_q_ABCD_q(Mm,q,1,1);
  end