%--------------------------------------------------------------------------
% FTE_zernike_content_of_LIGO_map
%
% A Matlab example function which uses zernike Finesse Tools functions to 
% look at the zernike polynomials which can be used to describe/recreate a 
% particular map surface, in this case a synthetic mirror map based on the
% Advanced LIGO mirror map etm08. In this example the mirror map is read
% and decomposed into Zernike polynomials.  The original map is plotted as 
% well as a map created from a sum of the relevnat Zernike polynomials.
% Finally the example outputs a table of the largest polynomials present in
% the mirror map.
%
% Part of the Simtools package, http://www.gwoptics.org/simtools
% Charlotte Bond    10.11.2010
%--------------------------------------------------------------------------
%

clear all;
    
% Input parameters, maximum n polynomial to use, input and output
% filenames
map_filename='test_map.txt';
n_max=16;
results_filename='map_zernike_content';

% Read in LIGO map to FT map structure
map=FT_read_surface_map(map_filename);

% Data points with a value 123456nm are defined as outside the mirror for
% this example
idx = find(map.data==123456);
map.data(idx) = nan;
map.nan = isnan(map.data);
map.notnan = ~map.nan;
    
% Recenter map
map=FT_recenter_mirror_map(map);
    
% Perform convolution and save results in structure zc
zc=FT_zernike_map_convolution(map,n_max,results_filename);
    
% Recreate map from zernike polynomial amplitudes given in zc, and plot
% the real and zernike maps for comparision.
[real_map,zernike_map]=FT_compare_real_and_zernike_maps(map,zc);
    
% List the 10 largest Zernike polynomials in the map
FT_list_zernike_content(zc,10,1);
    
