%--------------------------------------------------------------------------
% function [zc] =
% FT_zernike_content_of_1D_map(data_in,n_max,results_filename)
%
% A function for Matlab which fits a range of 1D zernike polynomials to 1D
% surface data and saves the relevant amplitudes of these polynomials.
%
% data_in:      1D surface data to be fitted to
% nmax:        the maximum order of the polynomials to be fitted to the
%               data.  All polynomials from 0 to n_max are fitted.
% results_filename: file to save results to
%
% zc:           structure to save zernike amplitudes to.
%
% Charlotte Bond    20.12.2011
%--------------------------------------------------------------------------
%

function [zc] = FT_zernike_content_of_1D_data(data_in,nmax,results_filename)

    
    [idx]=find(~isnan(data_in));
    
    data=data_in(idx);
    Zdata(1:length(idx))=0;
    
    zc = FT_init_zernike_coefficients(nmax);
    
    for n=0:n_max
        
        n
        
        for m=n-2*floor(n/2):2:n
            
            
            
            [a,z] = FT_fit_and_remove_1D_zernike_polynomial(data,n,m,0);
            
            %[a,z] = FT_fit_and_remove_1D_zernike_polynomial(data,n,m,a);
            %a

            zc = FT_update_zernike_coefficient(zc,n,m,a);
            
            
            Zdata = Zdata + a*FT_1D_zernike_polynomial(n,m,'horizontal',length(Zdata),ceil(length(Zdata)/2));
            
            data=z;
            
        end
        
        i=1;
                
    end
    
    figure
        hold on;
        
        plot(data_in(idx),'r','LineWidth',3)
        plot(Zdata,'k--','LineWidth',3)
        
        plot(z,'b','LineWidth',3)

    save(results_filename,'zc','data_in')

end

