%--------------------------------------------------------------------------
% function [zc] = FT_update_zernike_coefficient(zc,n,m,A)
%
% A function for Matlab which updates a specific Zernike coefficient stored
% in the structure zc (see FT_init_zernike_coefficients.m).
%
% zc:       Structure storing Zernike coefficients
% n,m:      Zernike indices of specific coefficient to be updated
% A:        Amplitude/coefficient of specific polynomial Znm to be updated
%
% Part of the Simtools package, http://www.gwoptics.org/simtools
% Charlotte Bond    08.08.2012
%--------------------------------------------------------------------------
%

function [zc] = FT_update_zernike_coefficient(zc,n,m,A)
    
    % Find location of given polynomial in zc
    idx1 = find(zc.n==n);
    idx2 = find(zc.m(idx1)==m);

    % Update ampltiude of Znm
    zc.amp(idx1(idx2)) = A;

end

