%--------------------------------------------------------------------------
% function [map_out] = FT_remove_zernike_polynomial_from_map(map,n,m,A)
%
% A Matlab function which removes a specific Zernike polynomial, Z_n^m from
% the surface of a mirror map.
%
% map:      Surface map
% n/m:      Indices of zernike polynomial to be removed        
% A:        Amplitude of zernike polynoial to be removed
%
% map_out:  The surface map with the polynomial removed
%
% Part of the Simtools package, http://www.gwoptics.org/simtools
% Charlotte Bond    05.01.10
%--------------------------------------------------------------------------
%

function [map_out]=FT_remove_zernike_polynomial_from_map(map,n,m,A)
  
  [rows,cols]=size(map.data);
  
  % Find the radius of the map
  r=FT_find_map_radius(map);
  
  % Compute Zernike polynomial
  Z=A*FT_zernike_polynomial_for_grid(cols,rows,map.x0,map.y0,r,r,n,m);
  
  % Remove Zernike polynomial from the map surface 
  map_out=map;
  [idx]=map_out.notnan; 
  map_out.data(idx)=map_out.data(idx)-Z(idx);

end