%--------------------------------------------------------------------------
% function [c_min,c_max] = FT_plot_zernike_polynomial(n,m)
% 
% A Matlab function which calculates and plots the surface heights on a
% disc defined by a specific Zernike polynomial.
%
% n:    Zernike polynomial index, n >= 0
% m:    Zernike polynomial index, can have values between -n and +n in
%       steps of 2.
% 
% Z:    Zernike height data
% c:    Maximum of abs(Z).
%
% Part of the Simtools package, http://www.gwoptics.org/simtools
% Charlotte Bond    06.12.09
%--------------------------------------------------------------------------


function [Z,c] = FT_plot_zernike_polynomial(n,m)

    % Define surface area
    x=-1000:1000;
    y=-1000:1000;

    % Make unit surface area
    [X,Y]=meshgrid(x/1000,y/1000);

    % Define angular and radial coordinates
    phi=atan2(Y,(X));
    rho=sqrt(X.^2+Y.^2);

    % Calculate Zernike surface heights
    Z=FT_Znm(n,m,rho,phi);

    % Plot the surface
	figure
    surf(X,Y,Z,'edgecolor','none')
    view(2)

    axis tight;
    axis square;

    colorbar();

    % Set symetric limits
	c=max(max(abs(Z)));
    c_min=-(c);
    c_max=(c);
    caxis([c_min c_max]);

    % Set colour map
    cmap=FT_flip_colormap;
    colormap(cmap);

    grid off;

end

