%--------------------------------------------------------------------------
% function [zc] = FT_init_zernike_coefficients(nmax)
%
% A function for Matlab which initiates the structure zc which stores
% indices and coefficients of Zernike polynomials.  I.e. a surface can be
% described by a sum of Zernike polynomials, with the amplitudes of the
% individual polynomials stored in this structure.
%
% namx:     Maximum order (n) of the Zernike polynomials coefficients to be
%           stored in zc.
% 
% zc:       Returned zernike coeffcients structure
%           zc.n:   Zernike radial index
%           zc.m:   Zernike azimuthal index
%           zc.amp: Zernike amplitude/ coefficient
%
% Part of the Simtools package, http://www.gwoptics.org/simtools
% Charlotte Bond    08.08.2012
%--------------------------------------------------------------------------
%

function [zc] = FT_init_zernike_coefficients(nmax)

    baseid = 'init_zernike_coefficients';

    % Error messages
    % nmax must be a positive integer
    if (round(nmax)~=nmax || nmax<0)
        result='Invalid input: nmax must be a positive integer';
        msgid=[baseid,':checkarguments']
        error(msgid,result);
    end

    % Initiate Zernike coefficients structure
    zc.amp(1:nmax+1,1:nmax+1)=nan;
    zc.n(1:nmax+1,1:nmax+1)=nan;
    zc.m(1:nmax+1,1:nmax+1)=nan;
    
    nstart = 0;
    
    % Fill possible coefficients with zeros
    for n=0:nmax
        i=0;
        for m=-n:2:n
            
            % Store values
            i = i+1;
            zc.amp(n+1,i) = 0;
            zc.n(n+1,i) = n;
            zc.m(n+1,i) = m;            
        end
    end

end

