%--------------------------------------------------------------------------
% function [A] = FT_get_zernike_coefficient(zc,n,m)
%
% A function for Matlab which retrives the amplitude (coefficient) for a
% given Zernike polynomial, defined by indices n,m, as stored in the
% structure zc.
%
% zc:       Structure storing Zernike coefficients and relative indices.
% n,m:      The Zernike indices for the polynomial whose amplitude is to be
%           returned.
%
% A:        Returned amplitude of Zernike polynomial Z_n,m.
%
% Part of the Simtools package, http://www.gwoptics.org/simtools
% Charlotte Bond    25.04.2012
%--------------------------------------------------------------------------
%

function [A] = FT_get_zernike_coefficient(zc,n,m)
 
    % Find location of given polynomial (n,m) in zc structure
    idx1 = find(zc.n==n);
    idx2 = find(zc.m(idx1)==m);
    
    % Return the amplitude
    A = zc.amp(idx1(idx2));

end

