%
%--------------------------------------------------------------------------
% function [map,zernike_map] = FT_compare_real_and_zernike_maps(map,zc)
% 
% A function for Matlab which creates a map from a sum of Zernike 
% polynomials for comaprision with a 'real' mirror map.  The function plots
% the real and Zernike maps with the same z-axis limits, for an accurate
% comparision.
%
% map:          Real/ original map
% zc:           Structure containing amplitudes of Zernike polynomials to 
%               be used to create the Zernike map.  
%
% zernike_map:  Returned map created from sum of zernike polynomials.
%
% Part of the Simtools package, http://www.gwoptics.org/simtools
% Charlotte Bond    03.01.10
%--------------------------------------------------------------------------
%

function [map,zernike_map] = FT_compare_real_and_zernike_maps(map,zc)
        
    % Create zernike map from Zernike amplitudes
    zernike_map=FT_create_zernike_polynomial_map(map,zc);
    
    % Plot original map and get z-axis limits for this map
    [z_min,z_max]=FT_plot_mirror_map(map,0);
    
    % Plot zernike map
    FT_plot_mirror_map(zernike_map,0);
    
    % Make a symmetric color mapping
    c_max=max(abs([z_max z_min]));
    set(gca, 'CLim', [-c_max c_max]);
    set(gca, 'ZLim', [-c_max c_max]);
    
end

