%--------------------------------------------------------------------------
% function [Z] = FT_Znm(n,m,rho,phi)
%
% Function for Matlab which calculates a specific Zernike polynomial
% defined by indices n and m.
%
% n:    Radial index.  n>=0 and an integer.
% m:    Azimuthal index.  m<=n and an integer.  n-m must be a multiple of
%       2.  Negative m represents the odd polynomial (using sin(m*phi)) and
%       positive represents the even polynomial (cos(m*phi)).
% rho:  Normalised radial coordinate.  The Zernike polynomial is only
%       defined inside the region where rho<=1.
% phi:  Angular coordinate [rad].
%
% Z:    Returned surface heights for the given polynomial
%
% Part of the Simtools package, http://www.gwoptics.org/simtools
% Charlotte Bond    25.04.2012
%--------------------------------------------------------------------------
%

function [Z] = FT_Znm(n,m,rho,phi)

    % Calculate radial polynomial
    Rnm = FT_Rnm(n,m,rho); 
        
    % Kronecker delta for m and 0, 1 for m=0 and 0 otherwise
    if (m==0)
        delta_m=1;
    else
        delta_m=0;
    end

    % Normalisation-> not used
    N=sqrt(2*(n+1)/(1+delta_m));

    % Calculate surface heights
    if (m<0)
        Z=Rnm.*sin(abs(m)*phi);
    else
        Z=Rnm.*cos(abs(m)*phi);
    end

    % Outside the optical surface (outside the unit disc) is set to nan
    outside_surface=find(rho>1);
    Z(outside_surface)=nan;

end

