%--------------------------------------------------------------------------
% function [Z] = FT_1D_zernike_polynomial(n,m,option,points,R)
%
% A function for Matlab which returns the surface heights for a given
% Zernike polynomial Z_n^m, at y = 0 ('horizontal') or x = 0 ('vertical').
%
% n:        radial zernike index, must be a positive integer.
% m:        azimuthal zernike index, must be an integer and n-m must be
%           even.
% option:   'horizontal':  take horizontal slice.
%           'vertical':     take vertical slice.
% points:   number of data points.
% R:        radius of zernike disc in data points.
%
% Charlotte Bond    20.12.2011
%--------------------------------------------------------------------------
%

function [Z] = FT_1D_zernike_polynomial(n,m,option,points,R)

    zdata = FT_zernike_polynomial_for_grid(points,points,(points+1)/2,(points+1)/2,R,R,n,m);

    Z = FT_select_1D_data(zdata,option,(points+1)/2);
    
    
end

