%--------------------------------------------------------------------------
% function [data] = FT_stitch_data(data1,data2)
% 
% A function for Matlab which stitches together two vectors of data.
%
% data1:    First section of data
% data2:    Second section of data
%
% data:     Returned stitched data
%
% Part of the Simtools package, http://www.gwoptics.org/simtools
% Charlotte Bond    05.10.2012
%--------------------------------------------------------------------------
%

function [data] = FT_stitch_data(data1,data2)

    L1 = length(data1);
    L2 = length(data2);
    
    % Initiate stitched data
    data(1:L1+L2) = 0;
    
    % Stich data together
    data(1:L1) = data1(:);
    data(L1+1:L2+L1) = data2(:);

end

