%--------------------------------------------------------------------------
% function [ h hcb ] = FT_imagescNAN(x,y,data,cm,nanclr)
%
% Plots a 2D distribution with IMAGESC but replaces the NaN values with a
% specific colour
%
% x/y:              x and y values
% data:             Real 2D data to plot       
% cm:               Colourmap to use
% nanclr:           3 element RGB vector to use for NaN colour
%
% Example
%   a=peaks;
%   a(a < 0.5) = nan;
%   FT_imagescNAN(a,hot,[0 1 1]) %# [0 1 1] is cyan
%
% Code from:
%  http://stackoverflow.com/questions/8481324/contrasting-color-for-nans-in-imagesc
%
% Daniel Brown    19.01.2013
%--------------------------------------------------------------------------
function [ h hcb ] = FT_imagescNAN(x,y,data,cm,nanclr)
    % IMAGESC with NaNs assigning a specific color to NaNs

    %# find minimum and maximum
    amin=min(data(:));
    amax=max(data(:));
    %# size of colormap
    n = size(cm,1);
    %# color step
    dmap=(amax-amin)/n;

    %# standard imagesc
    him = imagesc(x,y,data);
    %# add nan color to colormap
    colormap([nanclr; cm]);
    %# changing color limits
    caxis([amin-dmap amax]);
    %# place a colorbar
    hcb = colorbar;
    %# change Y limit for colorbar to avoid showing NaN color
    ylim(hcb,[amin amax])

    if nargout > 0
        h = him;
    end
end

