%--------------------------------------------------------------------------
% FTE_map_preparation_06.m
%
% An example script for Matlab demonstrating the use of some of the tools
% required to read and prepare maps for FINESSE.  06 of 06 example scripts
% where the data is read and prepared for use in FINESSE and map files are
% written in the required format for use in FINESSE.
% 
% Charlotte Bond    30.01.2013
%--------------------------------------------------------------------------
%

clear all;

% Example map
filename = 'CVI1-S1-BC.asc';

% Read map in .asc format
map = FT_read_zygo_map(filename,2)

% Prepare the map for use in FINESSE simulations
map_out = FT_prepare_phase_map_for_finesse(map,[0,0],'constant');