%--------------------------------------------------------------------------
% FTE_map_preparation_05.m
%
% An example script for Matlab demonstrating the use of some of the tools
% required to read and prepare maps for FINESSE.  05 of 06 example scripts
% where the data is read, prepared and curvature, offset and tilt is 
% removed.
% 
% Charlotte Bond    30.01.2013
%--------------------------------------------------------------------------
%

clear all;

% Example map
filename = 'CVI1-S1-BC.asc';

% Read map in .asc format
map = FT_read_zygo_map(filename,2)

% Recnetering the map
map = FT_recenter_mirror_map(map);

% Removing invalid elements
map = FT_remove_elements_outside_map(map);

% Removing zernike curvature
[map,zc] = FT_remove_zernike_curvatures_from_map(map,'constant');

% Calculating equivalent radius of curvature
R = map.xstep*FT_find_map_radius(map);
A2 = FT_get_zernike_coefficient(zc,2,0);
OF2 = FT_zernike_optical_features(A2,R,2,0);
 
% Remove zernike offset
map = FT_remove_zernike_offset_from_map(map);

% Equivalent offset
A0 = FT_get_zernike_coefficient(zc,0,0);
OF0 = FT_zernike_optical_features(A0,R,0,0);
 
% Remove zernike tilt
map = FT_remove_zernike_tilt_from_map(map);

% Equivalent mis-alignements
A1o = FT_get_zernike_coefficient(zc,1,-1);
OF1o = FT_zernike_optical_features(A1o,R,1,-1);
A1e = FT_get_zernike_coefficient(zc,1,1);
OF1e = FT_zernike_optical_features(A1e,R,1,1);

% Plot map
FT_plot_mirror_map(map,0)

% Output removed parameters
fprintf('--------------------------------------------------------------\n')
fprintf('Mirror diameter:               %g cm \n',2*R*100)
fprintf('Zernike amplitude (Z20):       %g nm \n',A2)
fprintf('Equivalent ROC:                %g m \n',OF2.value)
fprintf('Zernike amplitude (Z00):       %g nm \n',A0)
fprintf('Equivalent offset:             %g nm \n',OF0.value)
fprintf('Zernike amplitude (Z1-1):      %g nm \n',A1o)
fprintf('Equivalent tilt (ybeta):       %g urad \n',OF1o.value*1e6)
fprintf('Zernike amplitude (Z11):       %g nm \n',A1e)
fprintf('Equivalent tilt (xbeta):       %g urad \n',OF1e.value*1e6)
fprintf('--------------------------------------------------------------\n')
