%--------------------------------------------------------------------------
% FTE_map_preparation_03.m
%
% An example script for Matlab demonstrating the use of some of the tools
% required to read and prepare maps for FINESSE.  03 of 06 example scripts
% where the data is read, initial preparation is carried out and the 
% curvature is removed from the map.
% 
% Charlotte Bond    30.01.2013
%--------------------------------------------------------------------------
%

clear all;

% Example map
filename = 'CVI1-S1-BC.asc';

% Read map in .asc format
map = FT_read_zygo_map(filename,2)

% Recnetering the map
map = FT_recenter_mirror_map(map);

% Removing invalid elements
map = FT_remove_elements_outside_map(map);

% Removing zernike curvature
[map,zc] = FT_remove_zernike_curvatures_from_map(map,'constant');

% Calculate equivalent radius of curvature
R = map.xstep*FT_find_map_radius(map);
A = FT_get_zernike_coefficient(zc,2,0);
OF = FT_zernike_optical_features(A,R,2,0);

% Plot mirror
FT_plot_mirror_map(map,0)

% Output editing details
fprintf('--------------------------------------------------------------\n')
fprintf('Mirror diameter:               %g cm \n',2*R*100)
fprintf('Zernike amplitude (Z20):       %g nm \n',A)
fprintf('Equivalent ROC:                %g m \n',OF.value)
fprintf('--------------------------------------------------------------\n')

