%--------------------------------------------------------------------------
% FTE_map_preparation_02.m
%
% An example script for Matlab demonstrating the use of some of the tools
% required to read and prepare maps for FINESSE.  02 of 06 example scripts
% where the data is read and initial preparation is carried out: removing
% invalid points and recentering.
% 
% Charlotte Bond    30.01.2013
%--------------------------------------------------------------------------
%

clear all;

% Example map
filename = 'CVI1-S1-BC.asc';

% Read map in .asc format
map = FT_read_zygo_map(filename,2)

% Recnetering the map
map = FT_recenter_mirror_map(map);

% Removing invalid elements
map = FT_remove_elements_outside_map(map)

% Plot mirror map
FT_plot_mirror_map(map,0)