
clear all;

% FINESSE location
katpath = '/Applications/finesse/';

% Initialise Finesse
setenv('FINESSE_DIR',katpath)
FT = FT_init_Finesse();

% Input kat file
inname = 'example_cav.kat'

% Output kat file
katname = 'run_example_cav.kat';

% Read in 'blocks' from kat file
blocks = FT_read_blocks_from_file(inname);

% Copy individual blocks across
outbl(1) = FT_copy_block(blocks,'FPcav');
outbl(2) = FT_copy_block(blocks,'map');
outbl(3) = FT_copy_block(blocks,'HOMs');
outbl(4) = FT_copy_block(blocks,'detectors');

% Add block for x axis
outbl(5) = FT_create_new_block('xaxis');
outbl(5) = FT_add_line_to_block(outbl(5),'xaxis ETM phi lin -90 90 500');

% Add block for y axis
outbl(6) = FT_create_new_block('yaxis');
outbl(6) = FT_add_line_to_block(outbl(6),'yaxis log abs');

% Write katfile
FT_write_blocks_into_file(outbl,katname);
    

% Run Finese and read the simulation data
%--------------------------------------------------------------------------
Run = FT_create_new_kat_run();
Run.filename = katname;
Run = FT_run_kat_simulation(FT,Run,1);
%--------------------------------------------------------------------------


% Plot result
figure
    plot(Run.x,Run.y,'LineWidth',2)
    grid on;
    set(gca,'YScale','Log')
    xlabel('ETM tuning [deg]')
    ylabel('Circulating power [W]')
    
        


