%--------------------------------------------------------------------------
% FTE_FB_expansion_of_LG33.m
%
% A Matlab example illustrating the use of the function
% FT_FB_expansion_of_LG_beam.m.  In this example the Laguerre-Gauss mode
% LG33 is expressed as an expansion in a Fourier-Bessel (FB) series.
%
% Part of the Simtools package, http://www.gwoptics.org/simtools
% Charlotte Bond    08.02.2012
%--------------------------------------------------------------------------
%

clear all;

% Number of terms to use in the expansion
num_terms = 100;
    
% LG indices and beam/ mirror parameters
p=3;
l=3;
w = 3.5e-2;
a = 0.175;

% Reduced radiation constant (see FT_FB_expansion_of_LG_beam.m)
X = 0.4;
    
% Radial coordinates
r = -a:2*a/1000:a;
    
% Intensity of beam as sum of bessel beams
I = FT_FB_expansion_of_LG_beam(p,l,w,a,r,X,num_terms);
    
% Compare with intensity profile of typical LG beam
gp=FT_init_gauss_param(1064e-9,1,'z',0,'w0',w);
field = FT_LG_field(gp,p,l,r,r,[0,0,0]);
[rows,cols]=size(field);

% Normalise power in field for comparision
I_ref = abs(field(:,round(cols/2))).^2/FT_power_in_field(field,r,r);    
    
% Plot fields
figure
    hold on;
    
    plot(r,I,'r','LineWidth',3)
    plot(r,I_ref,'k--','LineWidth',3)    
    grid on;
    xlabel('r [m] ')
    ylabel('Intensity [Wm^{-2}] ')
    legend('Sum of bessel functions','LG intensity')
    title(sprintf('LG_{%g%g} intensity',p,l))


