%--------------------------------------------------------------------------
% function [U,c,p] = FT_thermal_distortion(beam,mirror,r,option,num_terms)
%
% A function for Matlab which calculates the thermal distortion of a mirror
% due to heating from an incident laser beam and absortion in the mirror.  
% The function returns the distortion of the surface and the parameters c 
% and p for the closest (Gaussian weighted) fit paraboloid.
%
% N.B. Currently only valid for coating absorption. 
%
% beam:     Structure storing beam parameters (FT_init_thermal_beam.m)
% mirror:   Structure storing mirror parameters (FT_init_thermal_mirror.m)
% r:        Radial coordinate [m]
% option:   'coating':  Coating absorption
%           'bulk':     Bulk (substrate) absorption
% num_terms:Number of terms to use in approximation of thermal distortion.
%
% U:        Returned thermal distortion [m]
% c,p:      Returned parameters for fitted paraboloid:
%           Z = c*r^2+p
%
% Part of the Simtools package, http://www.gwoptics.org/simtools
% Charlotte Bond    13.02.2012
%--------------------------------------------------------------------------
%

function [U,c,p] = FT_thermal_distortion(beam,mirror,r,option,num_terms)
    
    % Calculate thermal distortion from coating absorption
    if strcmp(option,'coating')
        
        U = FT_thermal_distortion_from_coating_absorption(beam,mirror,r,num_terms);
        [c,p] = FT_approximate_paraboloid_for_thermal_distortion(beam,mirror,num_terms);
        
    % Calculate distortion from bulk absorption
    elseif strcmp(option,'bulk')
       
        % Currently only valid for coating absorption
        
    end


end

