%--------------------------------------------------------------------------
% function [Temp] = FT_temperature_field(beam,mirror,r,z,option,num_terms)
%
% A Matlab function which calculates the temperature field in a mirror due 
% to an incidnet beam and absorption in the bulk (substrate) or coating of
% the mirror.
%
% beam:     Structure containing beam parameters (FT_init_thermal_beam.m)
% mirror:   Structure containing mirror parameters 
%           (FT_init_thermal_mirror.m)
% r:        Radial coordinate [m]
% z:        z (depth) coordinate along the optical axis [m]
% option:   'coating':  Calculate temperature field from coating 
%                       absorption.
%           'bulk':     Calculate temperature field from bulk absorption.
% num_terms:Number of terms to include in approximation of temperature
%           field (generally 50 terms will recreate the field well).
%
% Temp:     Returned temperature field.
%
% Part of the Simtools package, http://www.gwoptics.org/simtools
% Charlotte Bond    07.02.2012
%--------------------------------------------------------------------------
%

function [Temp] = FT_temperature_field(beam,mirror,r,z,option,num_terms)

    % Calculate temperature field from coating absorption
    if strcmp(option,'coating')
        Temp = FT_temperature_field_from_coating_absorption(beam,mirror,r,z,num_terms);        
    % Calculate temperature field from bulk absorption
    elseif strcmp(option,'bulk')   
        Temp = FT_temperature_field_from_bulk_absorption(beam,mirror,r,z,num_terms);
    end

end

