%--------------------------------------------------------------------------
% function [L] = FT_ordinary_LaguerrePol(n,x)
%
% A function for Matlab which returns the values for an ordianry Laguerre
% Polynomial, L_n(x).
%
% n:    Polynomial index
% x:    x coordinate
%
% L:    Returned polynmial values
%
% Part of the Simtools package, http://www.gwoptics.org/simtools
% Charlotte Bond    07.02.2012
%--------------------------------------------------------------------------
%

function [L] = FT_ordinary_LaguerrePol(n,x)

    L=0;
    
    % Calculate polynomial
    for k=0:n
        L = L + ((-1)^k/factorial(k)) * nchoosek(n,k) * x.^k; 
    end

end

