%--------------------------------------------------------------------------
% function [mirror] = FT_init_thermal_mirror(dn_dT,Cabs,Babs,K,E,a,h)
%
% A Matlab function which initalises the thermal mirror structure which 
% stores parameters and material properties for a mirror for use in 
% thermal calculations, particuarly calculating thermal lenses and 
% distortions.
%
% dn_dT:    Temperature index coefficient [/K]
% Cabs:     Absorption in the coating
% Babs:     Absorption in the bulk (substrate)
% K:        Thermal conductivity [W/m/K]
% E:        Emissivity
% alpha:    Thermal expansion coefficient [/K]
% Y:        Young's modulus [N/m^2]
% pois:     Poisson ratio
% a:        mirror radius [m]
% h:        mirror thickness [m]
% 
% mirror:   structure storing parameters
%
% Part of the Simtools package, http://www.gwoptics.org/simtools
% Charlotte Bond    09.02.2012
%--------------------------------------------------------------------------
%

function [mirror] = FT_init_thermal_mirror(dn_dT,Cabs,Babs,K,E,alpha,Y,pois,a,h)

    mirror.dn_dT = dn_dT;
    mirror.Cabs = Cabs;
    mirror.Babs = Babs;
    mirror.K = K;
    mirror.E = E;
    mirror.alpha = alpha;
    mirror.Y = Y;
    mirror.pois = pois;
    mirror.a = a;
    mirror.h = h;
    % Add in stefan-boltzmann constant
    mirror.oSB = 5.67e-8;
    % Set T0
    mirror.T0 = 300;
    mirror.X = 4*mirror.E*mirror.oSB*mirror.T0^3*mirror.a/mirror.K;

end

